﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Diagnostics;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.PaymentService;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class PaymentHistoryManager : AHOBPRBaseBO
    {
        string connectionInfo = string.Empty;
        const string UNKNOWN_PAYPLAN_CODE = "U";
        public PaymentHistoryManager() { }
        public PaymentHistoryManager(string dbConnInfo)
        {
            connectionInfo = dbConnInfo;
        }

        public Dictionary<DateTime, PayGradeHistoryData> GetRegistrantHistory(string edipi)
        {
            if (string.IsNullOrEmpty(edipi)) throw new ArgumentNullException(nameof(edipi));
            if (!EdipiValidator.IsValid(edipi)) throw new ArgumentException($"Value of parameter edipi ({edipi}) is not valid.");
            var history = GetPaymentHistory(edipi);
            var dictionary = (history.Count > 0) ? CreateDictionary(history) : new Dictionary<DateTime, PayGradeHistoryData>();
            return dictionary;
        }

        private Dictionary<DateTime, PayGradeHistoryData> CreateDictionary(List<PayGradeHistory> history)
        {
            //
            var payGradeHistory = new Dictionary<DateTime, PayGradeHistoryData>();
            foreach (var entry in history)
            {
                var data = entry?.payGradeHistoryData;
                if (data != null && !payGradeHistory.ContainsKey(data.payGradeDate))
                {
                    payGradeHistory.Add(data.payGradeDate, data);
                }
            }
            return payGradeHistory;
        }
        private List<PayGradeHistory> GetPaymentHistory(string edipi)
        {
            var importer = new PaymentServiceImporter();
            return importer.GetPaymentServiceData(edipi);
        }

        public STD_PAYPLAN LookupPayPlan(PayGradeHistoryData payGradeData, string code)
        {          
            STD_PAYPLAN result = null;
            using (var db = GetLocalContext(connectionInfo))
            {
                if (payGradeData != null && !string.IsNullOrEmpty(payGradeData.payPlanCode))
                {

                    // Write(payGradeData, code);
                    result = db.STD_PAYPLANs.Where(x => x.SERVICE_CODE == code && x.PAY_PLAN_CODE_SHORT == payGradeData.payPlanCode).AsEnumerable().FirstOrDefault(p => IsMatch(p, payGradeData, code));

                }
                else
                {
                    result = db.STD_PAYPLANs.FirstOrDefault(x => x.SERVICE_CODE == UNKNOWN_PAYPLAN_CODE);
                }
            }
            return result;
        }

        //private void Write(PayGradeHistoryData payGradeData, string serviceCode)
        //{
        //    if (payGradeData != null)
        //    {
        //        Console.WriteLine($"PayGradeCode: {payGradeData.PayGradeCode.ToLowerInvariant()} PayPlanCode: {payGradeData.payPlanCode.ToLowerInvariant()} ServiceRankName: {payGradeData.serviceRankNameTxt.ToLowerInvariant()} ");
        //        Console.WriteLine($"RankNameCode: {payGradeData.serviceRankNameCode.ToLowerInvariant()}  ServiceCode: {serviceCode.ToLowerInvariant()}");
        //    }
        //    else { Console.WriteLine("Paygrade data was null"); }
        //}

        private bool IsMatch(STD_PAYPLAN p, PayGradeHistoryData payGradeData, string serviceCode)
        {
            //WriteoutAlg(p, payGradeData, serviceCode);
            return p.PAYGRADE_CODE.ToLowerInvariant() == payGradeData?.PayGradeCode?.ToLowerInvariant()
                && p.PAY_PLAN_CODE_SHORT.ToLowerInvariant() == payGradeData?.payPlanCode?.ToLowerInvariant()
                && p.RANK_TEXT.ToLowerInvariant() == payGradeData?.serviceRankNameTxt?.ToLowerInvariant()
                && p.RANK_CODE.ToLowerInvariant() == payGradeData?.serviceRankNameCode?.ToLowerInvariant()
                && p.SERVICE_CODE.ToLowerInvariant() == serviceCode?.ToLowerInvariant();
        }

        //private void WriteoutAlg(STD_PAYPLAN p, PayGradeHistoryData payGradeData, string serviceCode)
        //{
        //    Console.WriteLine(new string('-', 40));
        //    Console.WriteLine($"{ p.PAYGRADE_CODE.ToLowerInvariant()} == {payGradeData.PayGradeCode.ToLowerInvariant()}=>{ p.PAYGRADE_CODE.ToLowerInvariant() == payGradeData.PayGradeCode.ToLowerInvariant()}");
        //    Console.WriteLine($"{ p.PAY_PLAN_CODE_SHORT.ToLowerInvariant() } == { payGradeData.payPlanCode.ToLowerInvariant()} =>{ p.PAY_PLAN_CODE_SHORT.ToLowerInvariant() == payGradeData.payPlanCode.ToLowerInvariant()}");
        //    Console.WriteLine($"{ p.RANK_TEXT.ToLowerInvariant() } == { payGradeData.serviceRankNameTxt.ToLowerInvariant()} => { p.RANK_TEXT.ToLowerInvariant() == payGradeData.serviceRankNameTxt.ToLowerInvariant()}");
        //    Console.WriteLine($"{ p.RANK_CODE.ToLowerInvariant() } == { payGradeData.serviceRankNameCode.ToLowerInvariant()} => { p.RANK_CODE.ToLowerInvariant() == payGradeData.serviceRankNameCode.ToLowerInvariant()}");
        //    Console.WriteLine($"{ p.SERVICE_CODE.ToLowerInvariant()} == { serviceCode.ToLowerInvariant()} => { p.SERVICE_CODE.ToLowerInvariant() == serviceCode.ToLowerInvariant()}");
        //}
    }

}
